"use client"
import React, { createContext, useState } from 'react';

export const FlashMessageContext = createContext();

export const FlashMessageProvider = ({ children }) => {
  const [flashMessage, setFlashMessage] = useState(null);

  const showFlashMessage = (message) => {
    setFlashMessage(message);
  };

  const clearFlashMessage = () => {
    setFlashMessage(null);
  };

  return (
    <FlashMessageContext.Provider
      value={{
        flashMessage,
        showFlashMessage,
        clearFlashMessage,
      }}
    >
      {children}
    </FlashMessageContext.Provider>
  );
};
