import db from '../../config/db'

export default function handler(req, res) {
  if (req.method === 'POST') {
    const date = new Date();
    let currentDay= String(date.getDate()).padStart(2, '0');
    let currentMonth = String(date.getMonth()+1).padStart(2,"0");
    let currentYear = date.getFullYear();
    let currentDate = `${currentYear}-${currentMonth}-${currentDay}`;

    const query = `select count(*) as found, date from puzzles where date = ? and words LIKE ?`;
    const values = [currentDate, '% '+req.body.value+", %"];
    db.query(query, values, (error, results) => {
      if (error) {
        res.status(500).json({ message: 'Error executing query' });
      } else {
        res.status(200).json(JSON.stringify(results));
      }
    });

  }
  else if (req.method === 'GET') {

    const date = new Date();
    let currentDay= String(date.getDate()).padStart(2, '0');
    let currentMonth = String(date.getMonth()+1).padStart(2,"0");
    let currentYear = date.getFullYear();
    let currentDate = `${currentYear}-${currentMonth}-${currentDay}`;

    const query = `select letters,mainletter,totalwords from puzzles where date = ?`;
    const values = [currentDate];

    db.query(query, values, (error, results) => {
      if (error) {
        console.error('Error executing MySQL query:', error);
        res.status(500).json({ message: 'Error executing query' });
      } else {
        res.status(200).json(JSON.stringify(results));
      }
    });

  } else {
    res.status(405).json({ message: 'Method Not Allowed' });
  }
}